using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Summary description for DlgDiscardQuarantineChangeReimbursement
	/// </summary>
	public class DlgDiscardQuarantineChangeReimbursement : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpReimbursement;
		private System.Windows.Forms.Button btnSave;
		private System.Windows.Forms.Button btnCancel;
		private Decimal _reimbursementCredit;
		private string _unitID;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.Label lblReimbursement;
		private System.Windows.Forms.Label lblDollar;
		private System.Windows.Forms.GroupBox grpPicture;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.TextBox txtUnitID;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updReimbursment;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgDiscardQuarantineChangeReimbursement()
		{
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC027.DlgDiscardQuarantineChangeReimbursement());
			// 
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="unitID"></param>
		/// <param name="reimbursementCredit"></param>
		public DlgDiscardQuarantineChangeReimbursement(string unitID, decimal reimbursementCredit)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC027.DlgDiscardQuarantineChangeReimbursement());
			//
			this._unitID = unitID;
			this.txtUnitID.Text = this._unitID;

			this._reimbursementCredit = reimbursementCredit;
			this.updReimbursment.Value = this._reimbursementCredit;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgDiscardQuarantineChangeReimbursement));
			this.grpReimbursement = new System.Windows.Forms.GroupBox();
			this.txtUnitID = new System.Windows.Forms.TextBox();
			this.lblDollar = new System.Windows.Forms.Label();
			this.lblReimbursement = new System.Windows.Forms.Label();
			this.lblUnitID = new System.Windows.Forms.Label();
			this.updReimbursment = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnSave = new System.Windows.Forms.Button();
			this.grpPicture = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpReimbursement.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updReimbursment)).BeginInit();
			this.grpPicture.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(304, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Edit Reimbursement";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 152);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpReimbursement
			// 
			this.grpReimbursement.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReimbursement.Controls.Add(this.txtUnitID);
			this.grpReimbursement.Controls.Add(this.lblDollar);
			this.grpReimbursement.Controls.Add(this.lblReimbursement);
			this.grpReimbursement.Controls.Add(this.lblUnitID);
			this.grpReimbursement.Controls.Add(this.updReimbursment);
			this.grpReimbursement.Location = new System.Drawing.Point(60, 32);
			this.grpReimbursement.Name = "grpReimbursement";
			this.grpReimbursement.Size = new System.Drawing.Size(240, 91);
			this.grpReimbursement.TabIndex = 0;
			this.grpReimbursement.TabStop = false;
			// 
			// txtUnitID
			// 
			this.txtUnitID.AccessibleDescription = "Unit I D ";
			this.txtUnitID.AccessibleName = "Unit I D ";
			this.txtUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitID.Location = new System.Drawing.Point(96, 20);
			this.txtUnitID.Name = "txtUnitID";
			this.txtUnitID.ReadOnly = true;
			this.txtUnitID.Size = new System.Drawing.Size(136, 20);
			this.txtUnitID.TabIndex = 1;
			this.txtUnitID.Text = "";
			// 
			// lblDollar
			// 
			this.lblDollar.Location = new System.Drawing.Point(156, 44);
			this.lblDollar.Name = "lblDollar";
			this.lblDollar.Size = new System.Drawing.Size(12, 20);
			this.lblDollar.TabIndex = 3;
			this.lblDollar.Text = "$";
			this.lblDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblReimbursement
			// 
			this.lblReimbursement.Location = new System.Drawing.Point(12, 44);
			this.lblReimbursement.Name = "lblReimbursement";
			this.lblReimbursement.Size = new System.Drawing.Size(104, 20);
			this.lblReimbursement.TabIndex = 2;
			this.lblReimbursement.Text = "Reimbursement";
			this.lblReimbursement.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblUnitID
			// 
			this.lblUnitID.Location = new System.Drawing.Point(12, 20);
			this.lblUnitID.Name = "lblUnitID";
			this.lblUnitID.Size = new System.Drawing.Size(88, 20);
			this.lblUnitID.TabIndex = 0;
			this.lblUnitID.Text = "Unit ID";
			this.lblUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updReimbursment
			// 
			this.updReimbursment.AccessibleDescription = "Reimbursement";
			this.updReimbursment.AccessibleName = "Reimbursement";
			this.updReimbursment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updReimbursment.DecimalPlaces = 2;
			this.updReimbursment.Location = new System.Drawing.Point(168, 44);
			this.updReimbursment.Maximum = new System.Decimal(new int[] {
																			999,
																			0,
																			0,
																			0});
			this.updReimbursment.Name = "updReimbursment";
			this.updReimbursment.Size = new System.Drawing.Size(64, 20);
			this.updReimbursment.TabIndex = 4;
			this.updReimbursment.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updReimbursment.Value = new System.Decimal(new int[] {
																		  0,
																		  0,
																		  0,
																		  0});
			this.updReimbursment.TextChanged += new System.EventHandler(this.updReimbursment_ValueChanged);
			this.updReimbursment.Leave += new System.EventHandler(this.updReimbursment_Leave);
			this.updReimbursment.ValueChanged += new System.EventHandler(this.updReimbursment_ValueChanged);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(224, 139);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnSave
			// 
			this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSave.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnSave.Location = new System.Drawing.Point(144, 139);
			this.btnSave.Name = "btnSave";
			this.btnSave.TabIndex = 1;
			this.btnSave.Text = "&OK";
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// grpPicture
			// 
			this.grpPicture.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpPicture.Controls.Add(this.pictureBox1);
			this.grpPicture.Location = new System.Drawing.Point(4, 32);
			this.grpPicture.Name = "grpPicture";
			this.grpPicture.Size = new System.Drawing.Size(52, 91);
			this.grpPicture.TabIndex = 4;
			this.grpPicture.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// DlgDiscardQuarantineChangeReimbursement
			// 
			this.AcceptButton = this.btnSave;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(304, 168);
			this.Controls.Add(this.grpPicture);
			this.Controls.Add(this.grpReimbursement);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnSave);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.hlphelpChm.SetHelpKeyword(this, "Discard_or_Quarantine.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(288, 192);
			this.Name = "DlgDiscardQuarantineChangeReimbursement";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Edit Reimbursement";
			this.Controls.SetChildIndex(this.btnSave, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpReimbursement, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpPicture, 0);
			this.grpReimbursement.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updReimbursment)).EndInit();
			this.grpPicture.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void btnSave_Click(object sender, System.EventArgs e)
		{
			_reimbursementCredit = updReimbursment.Value;
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		private void updReimbursment_Leave(object sender, System.EventArgs e)
		{
			try
			{
				_reimbursementCredit = updReimbursment.Value;
				btnSave.Enabled = true;
				this.errError.SetVbecsError(updReimbursment,""); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				btnSave.Enabled = false;
				this.errError.SetVbecsError(updReimbursment, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Get ReimbursementCredit
		/// </summary>
		public Decimal ReimbursementCredit
		{
			get 
			{
				return _reimbursementCredit;
			}
		}

		/// <summary>
		/// Handle value changed
		/// </summary>
		private void updReimbursment_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				_reimbursementCredit = updReimbursment.Value;
				btnSave.Enabled = true;
				this.errError.SetVbecsError(updReimbursment, ""); // **** 508 Compliance ***
			}
			catch(FormatException)
			{
				btnSave.Enabled = false;
			}
		}
	}
}
